/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIETLPINFO_H
#define PCIETLPINFO_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

class CPCIETlpInfoProperty
{
public:
  UInt8  mPropNum;
  UInt32 mDefault;
  UInt8  mDwNum;
  UInt8  mBitSize;
  UInt8  mBitOffset;
};

class CPCIETlpInfo
{
public:

  CPCIETlpInfo();
  ~CPCIETlpInfo();

  // ATTENTION: Do not modify order without changing order in source file
  enum Property 
  {
    PKTPROP_Length = 0,
    PKTPROP_Reserved023,
    PKTPROP_Attr,
    PKTPROP_EP,
    PKTPROP_TD,
    PKTPROP_Reserved013,
    PKTPROP_TC,
    PKTPROP_Reserved017,
    PKTPROP_Type,
    PKTPROP_Fmt,
    PKTPROP_Reserved007,
    PKTPROP_1stDWBE,
    PKTPROP_LastDWBE,
    PKTPROP_Tag,
    PKTPROP_RequesterID,
    PKTPROP_CfgReserved111,
    PKTPROP_CfgRegisterNumber,
    PKTPROP_CfgExtRegisterNumber,
    PKTPROP_CfgReserved107,
    PKTPROP_CfgFunctionNumber,
    PKTPROP_CfgDeviceNumber,
    PKTPROP_CfgBusNumber,
    PKTPROP_Mem64AddrHi,
    PKTPROP_Mem64AddrLo,
    PKTPROP_Mem64AddrRsvd151,
    PKTPROP_Mem32Addr,
    PKTPROP_Mem32AddrRsvd111,
    PKTPROP_MessageCode,
    PKTPROP_DWord1,
    PKTPROP_DWord2,
    PKTPROP_DWord3,
    PKTPROP_TLPType,
    PKTPROP_CompReqID,
    PKTPROP_CompCompID,
    PKTPROP_CompStatus,
    PKTPROP_CompByteCount,
    PKTPROP_CompBCM,
    PKTPROP_CompTag,
    PKTPROP_CompRsvd117,
    PKTPROP_CompLowerAddr,
    PKTPROP_DWord0,
    PKTPROP_END
  };

  enum TLPType
  {
    TLPTYPE_MRd = 0,
    TLPTYPE_MRdLk,
    TLPTYPE_MWr,
    TLPTYPE_IORd,
    TLPTYPE_IOWr,
    TLPTYPE_CfgRd0,
    TLPTYPE_CfgWr0,
    TLPTYPE_CfgRd1,
    TLPTYPE_CfgWr1,
    TLPTYPE_Msg,
    TLPTYPE_MsgD,
    TLPTYPE_MsgAS,
    TLPTYPE_MsgASD,
    TLPTYPE_Cpl,
    TLPTYPE_CplD,
    TLPTYPE_CplLk,
    TLPTYPE_CplDLk,
    TLPTYPE_Unknown,
    TLPTYPE_END
  };

  enum CompletionStatus
  {
    COMPSTATUS_SC,
    COMPSTATUS_UR,
    COMPSTATUS_CRS,
    COMPSTATUS_CA,
    COMPSTATUS_RSVD
  };

  static UInt8 getBitOffset( const EPCIESi& prop );
  static UInt8 getBitSize( const EPCIESi& prop );
  static UInt32 getDefault( const EPCIESi& prop );
  static UInt8 getDWNum( const EPCIESi& prop );

  static void setPropVal( const EPCIESi& prop, UInt32& currentVal, const UInt32& newOffsetValue );
  static UInt32 getPropVal( const EPCIESi& prop, const UInt32& currentVal );

  static TLPType TLPTypeGet( const UInt32& val );
  static void TLPTypeSet( UInt32& val, const TLPType& aType );

  static UInt32 getCompletionStatusVal( const CompletionStatus& cstatus );
  static CompletionStatus resolveCompletionStatusVal( const UInt32& cval );

  static UInt8 getBitOffset( const EPCIEPattern& prop );
  static UInt8 getBitSize( const EPCIEPattern& prop );
  static UInt8 getDWNum( const EPCIEPattern& prop );

  static void setPropVal( const EPCIEPattern& prop, UInt32& currentVal, const UInt32& newOffsetValue );
  static UInt32 getPropVal( const EPCIEPattern& prop, const UInt32& currentVal );

private:

  static const CPCIETlpInfoProperty mPropTable[];
  static CPCIETlpInfoProperty getPropertyInfo( const EPCIESi& prop );
  static CPCIETlpInfoProperty getPropertyInfo( const EPCIEPattern& prop );
};

#endif /* PCIETLPINFO_H */